#version 430


layout(points)       in;
layout(points)       out;
layout(max_vertices = 50) out;

layout (location = 0) in vec4 vs_PositionType[];
layout (location = 1) in vec4 vs_VelocityAge[];
layout (location = 2) in vec4 vs_AuxVecOne[];


layout (location = 0) out vec4 gs_PositionType;
layout (location = 1) out vec4 gs_VelocityAge;
layout (location = 2) out vec4 gs_AuxVecOne;

//particleEnums happens here
uniform float   emitCount1 = 5000; //SUN_ALPHA
uniform float   emitCount2 = 2000; //SUN_BETA
uniform float   emitCount3 = 200; //SHUTTLE
uniform float   emitCount4 = 5000; //Explosion
uniform float   emitCount5 = 30; //Explosion, ringburst?
uniform float   emitCount6 = 0; //Explosion, smokey
uniform float   emitCount7 = 400; //vent doodad
uniform float   emitCount8 = 100; //flying burger mustard / ketchup
uniform float   emitCount9 = 1000; //CARRIER_HYPER_SPACE
uniform float   emitCount10 = 0; //not used for anything yet

uniform float   emitCount11 = 30; //REACTOR_LIGHTNING_BOLTS
uniform float   emitCount12 = 200; //fireworks rocket
uniform float   emitCount13 = 15; //fireworks explosion



uniform float deltaTime;
uniform highp float randomSeed1;
uniform highp float randomSeed2;
uniform highp float randomSeed3;

uniform float particleEmissionMultiplier; 
uniform float gameTimeInSeconds;

//used for instant particles
uniform int isItInstant;
uniform int cycleCount;


#define HASHSCALE1 .1031

highp float hash12(vec2 p)
{
	vec3 p3 = fract(vec3(p.xyx) * HASHSCALE1);
  p3 += dot(p3, p3.yzx + 19.19);
  return 2.0*(fract((p3.x + p3.y) * p3.z) - 0.5);
}



vec4 permute(vec4 x){return mod(((x*34.0)+1.0)*x, 289.0);}
vec4 taylorInvSqrt(vec4 r){return 1.79284291400159 - 0.85373472095314 * r;}
vec3 fade(vec3 t) {return t*t*t*(t*(t*6.0-15.0)+10.0);}


float cnoise(vec3 P){
 vec3 Pi0 = floor(P); // Integer part for indexing
 vec3 Pi1 = Pi0 + vec3(1.0); // Integer part + 1
 Pi0 = mod(Pi0, 289.0);
 Pi1 = mod(Pi1, 289.0);
 vec3 Pf0 = fract(P); // Fractional part for interpolation
 vec3 Pf1 = Pf0 - vec3(1.0); // Fractional part - 1.0
 vec4 ix = vec4(Pi0.x, Pi1.x, Pi0.x, Pi1.x);
 vec4 iy = vec4(Pi0.yy, Pi1.yy);
 vec4 iz0 = Pi0.zzzz;
 vec4 iz1 = Pi1.zzzz;

 vec4 ixy = permute(permute(ix) + iy);
 vec4 ixy0 = permute(ixy + iz0);
 vec4 ixy1 = permute(ixy + iz1);

 vec4 gx0 = ixy0 / 7.0;
 vec4 gy0 = fract(floor(gx0) / 7.0) - 0.5;
 gx0 = fract(gx0);
 vec4 gz0 = vec4(0.5) - abs(gx0) - abs(gy0);
 vec4 sz0 = step(gz0, vec4(0.0));
 gx0 -= sz0 * (step(0.0, gx0) - 0.5);
 gy0 -= sz0 * (step(0.0, gy0) - 0.5);

 vec4 gx1 = ixy1 / 7.0;
 vec4 gy1 = fract(floor(gx1) / 7.0) - 0.5;
 gx1 = fract(gx1);
 vec4 gz1 = vec4(0.5) - abs(gx1) - abs(gy1);
 vec4 sz1 = step(gz1, vec4(0.0));
 gx1 -= sz1 * (step(0.0, gx1) - 0.5);
 gy1 -= sz1 * (step(0.0, gy1) - 0.5);

 vec3 g000 = vec3(gx0.x,gy0.x,gz0.x);
 vec3 g100 = vec3(gx0.y,gy0.y,gz0.y);
 vec3 g010 = vec3(gx0.z,gy0.z,gz0.z);
 vec3 g110 = vec3(gx0.w,gy0.w,gz0.w);
 vec3 g001 = vec3(gx1.x,gy1.x,gz1.x);
 vec3 g101 = vec3(gx1.y,gy1.y,gz1.y);
 vec3 g011 = vec3(gx1.z,gy1.z,gz1.z);
 vec3 g111 = vec3(gx1.w,gy1.w,gz1.w);

 vec4 norm0 = taylorInvSqrt(vec4(dot(g000, g000), dot(g010, g010), dot(g100, g100), dot(g110, g110)));
 g000 *= norm0.x;
 g010 *= norm0.y;
 g100 *= norm0.z;
 g110 *= norm0.w;
 vec4 norm1 = taylorInvSqrt(vec4(dot(g001, g001), dot(g011, g011), dot(g101, g101), dot(g111, g111)));
 g001 *= norm1.x;
 g011 *= norm1.y;
 g101 *= norm1.z;
 g111 *= norm1.w;

 float n000 = dot(g000, Pf0);
 float n100 = dot(g100, vec3(Pf1.x, Pf0.yz));
 float n010 = dot(g010, vec3(Pf0.x, Pf1.y, Pf0.z));
 float n110 = dot(g110, vec3(Pf1.xy, Pf0.z));
 float n001 = dot(g001, vec3(Pf0.xy, Pf1.z));
 float n101 = dot(g101, vec3(Pf1.x, Pf0.y, Pf1.z));
 float n011 = dot(g011, vec3(Pf0.x, Pf1.yz));
 float n111 = dot(g111, Pf1);

 vec3 fade_xyz = fade(Pf0);
 vec4 n_z = mix(vec4(n000, n100, n010, n110), vec4(n001, n101, n011, n111), fade_xyz.z);
 vec2 n_yz = mix(n_z.xy, n_z.zw, fade_xyz.y);
 float n_xyz = mix(n_yz.x, n_yz.y, fade_xyz.x); 
 return 2.2 * n_xyz;
}

float LCG(float seed, float modulus, float multiplier, float increment){
	float m=abs(modulus);
	float a= mod(abs(multiplier),m);
	float c= mod(abs(increment),m);
	//return mod(multiplier*seed+increment, modulus);
	return mod(a*seed+c, m);

	}

void emitParticles(int type)
{

  int num;
	float emitCount;


	if(type == 1){
		emitCount = emitCount1;
	}else if(type == 2){
		emitCount = emitCount2;
	}else if(type == 3){
		emitCount = emitCount3;
	}else if(type == 4){
		emitCount = emitCount4;
	}else if(type == 5){
		emitCount = emitCount5;
	}else if(type == 6){
		emitCount = emitCount6;
	}else if(type == 7){
		emitCount = emitCount7;
	}else if(type == 8){
		emitCount = emitCount8;
	}else if(type == 9){
		emitCount = emitCount9;
	}else if(type == 10){
		emitCount = emitCount10;
	}else if(type == 11){
		emitCount = emitCount11;
	}else if(type == 12){
		emitCount = emitCount12;
	}else if(type == 13){
		emitCount = emitCount12;
	}


	else{
		emitCount = 0;
	}

	vec3 directionArray[64];


	if(type == 4){
		float lcg0;
		float lcg1;
		float lcg2;
		float lcg3;
		vec3 normalLCG;

		float modulus = 12.3456789;

		lcg0=mod(pow(vs_PositionType[0].x,2)+pow(vs_PositionType[0].x,2)+pow(vs_PositionType[0].x,2),modulus);


		for( int i=0;i<64;i++){
			lcg1=hash12(vec2(lcg0, modulus));
			lcg2=hash12(vec2(lcg1, modulus));
			lcg3=hash12(vec2(lcg2, modulus));
			lcg0=hash12(vec2(lcg3, modulus));

			directionArray[i] = normalize(normalize(vec3(lcg1,lcg2,3*lcg3))+vec3(0,0,0.5));
		}
		for( int i=0;i<64;i++){
			lcg1=hash12(vec2(lcg0, modulus));
			lcg2=hash12(vec2(lcg1, modulus));
			lcg3=hash12(vec2(lcg2, modulus));
			lcg0=hash12(vec2(lcg3, modulus));
			
			normalLCG= normalize(vec3(lcg1,lcg2,lcg3));

			if(normalLCG.x<0.5){
				directionArray[i].x=-directionArray[i].x;
			}
			if(normalLCG.x<0.5){
				directionArray[i].y=-directionArray[i].y;
			}
		}
		directionArray[0]=vec3(0,0,1);
		directionArray[1]=vec3(0,0,1);
		directionArray[2]=vec3(0,0,1);
		directionArray[3]=vec3(0,0,1);



	}



	if(isItInstant == 1){
		num = int(emitCount);
	}else{
		num = int(particleEmissionMultiplier * deltaTime * emitCount);
	}

	//for lightning bolts only

	vec3 targetDirection = vs_VelocityAge[0].xyz;
	float distanceOffset = (vs_VelocityAge[0].w / 5.0f);

	vec3 startingPosition =  float(cycleCount) * distanceOffset * targetDirection.xyz;
	vec3 secondaryGoal = float(cycleCount + 1.0) * distanceOffset * targetDirection.xyz;
	vec3 primaryGoal = startingPosition + (distanceOffset * targetDirection.xyz / 2.0) + vec3(randomSeed1, randomSeed2, randomSeed3) * 2.0;



	for (int i = 0; i < num; i++){
		bool doEmit = true;
		float xfloat = hash12(vec2(randomSeed2 * (5*i+7), randomSeed1 * (8*i+13)));
		float yfloat = hash12(vec2(randomSeed1 * i * (i+1), randomSeed2));
		float zfloat = hash12(vec2(randomSeed2 * (2*i+1), randomSeed3 * (2*i+1)));

		float velocityFloat = (hash12(vec2(randomSeed3 * (5*i+1), randomSeed1 * (8*i+1))) + 1.0) / 2.0;
		float offsetFloat = (hash12(vec2(randomSeed3 * (9*i+1), randomSeed2 * (13*i+1))) + 1.0) / 2.0;


		vec3 positionVector = vec3(xfloat, yfloat, zfloat);

		positionVector = normalize(positionVector);

		float velocityMagnitude;

		vec4 positionTypePlaceholder = vec4(0.0);
		vec4 velocityAgePlaceholder = vec4(0.0);
		vec4 auxVecOnePlaceholder = vec4(0.0);
		
		switch(type){

			case(1):{
				velocityMagnitude = 25.0f; 
				vec3 pos = vs_PositionType[0].xyz + (positionVector * 300.0f);
				positionTypePlaceholder.xyz = pos;
				velocityAgePlaceholder.xyz = positionVector.xyz * velocityMagnitude;
				auxVecOnePlaceholder.xyz = pos;
				break;
				}
			case(2): {
				vec3 rotationdirection = vec3(-sin(atan(positionVector.y,positionVector.x)), cos(atan(positionVector.y,positionVector.x)), 0);
				velocityMagnitude = 50.0f;
				vec3 pos = vs_PositionType[0].xyz + (positionVector * 300.0f) * (1 + (0.2*randomSeed1));
				positionTypePlaceholder.xyz = pos;
				velocityAgePlaceholder.xyz = rotationdirection * velocityMagnitude;
				auxVecOnePlaceholder.xyz = pos;
				break;
				}
			case(3): {
				positionTypePlaceholder.xyz = vs_PositionType[0].xyz - (offsetFloat * vs_VelocityAge[0].xyz);
				velocityAgePlaceholder.xyz = normalize(vs_VelocityAge[0].xyz + positionVector / 3.0f) * (3.0 + velocityFloat);
				auxVecOnePlaceholder = vec4(vs_AuxVecOne[0].x,randomSeed2,randomSeed3, 0);

				break;
				}
			case(4): {
			//Debris Explosion
				doEmit = false;

				break;
			}
			case(5): {
				//Puff Up
				float delay=0.2;

				vec3 zAxis= normalize(vs_PositionType[0].xyz);
				vec3 yAxis=vec3(0,1,0);
				vec3 xAxis=vec3(1,0,0);
				vec3 yAxisSeed=vec3(zAxis.x+1.0,zAxis.y+1.0,zAxis.z+1.0);
				//Fix this so that it doesn't end up being paralell on (1,1,1)
				yAxis=normalize(cross(zAxis,yAxisSeed));
				xAxis=normalize(cross(zAxis,yAxis));


				velocityMagnitude = 10.0f;
				positionTypePlaceholder.xyz = vs_PositionType[0].xyz + positionVector*6;
				velocityAgePlaceholder.xyz = vec3(0,0,1)*velocityMagnitude;

				velocityAgePlaceholder.xyz= velocityAgePlaceholder.x*xAxis+velocityAgePlaceholder.y*yAxis+velocityAgePlaceholder.z*zAxis;
				float ps= clamp(tan(vs_AuxVecOne[0].y-delay),0.0,1.0);

				auxVecOnePlaceholder = vec4(ps, mod(randomSeed1,0.1)*mod(randomSeed2,0.1)*mod(randomSeed3,0.1),0, 0);
				break;
			}

			case(6): {
				//Total Explosion
				velocityMagnitude = 10.0f;
				positionTypePlaceholder.xyz = vs_PositionType[0].xyz + positionVector*pow(tan(vs_AuxVecOne[0].y),2)*10.0;
				velocityAgePlaceholder.xyz = positionVector * velocityMagnitude;

				float ps= clamp(tan(vs_AuxVecOne[0].y),0.0,2.0);
				auxVecOnePlaceholder = vec4(ps, mod(randomSeed1,0.1)*mod(randomSeed2,0.1)*mod(randomSeed3,0.1),0, 0); //(Particle size, random Noise for Smog, Smog or Main Body?)
				break;
			}
			case(7): {
				velocityMagnitude = 5.0f;
				positionTypePlaceholder.xyz = vs_PositionType[0].xyz + (positionVector / 2.0);
				velocityAgePlaceholder.xyz = (normalize(vs_PositionType[0].xyz) + positionVector / 2.0) * velocityMagnitude;
				auxVecOnePlaceholder = vec4(vs_PositionType[0].w , randomSeed2 , randomSeed3, 0); //particle planet is the ownerID
				break;
			}
			
			case(8): {

				float isItMustard = 0.0;

				velocityMagnitude = 5.0f;

				if(positionVector.z < 0.0){
					isItMustard = 1.0;
				}else{
				}

				positionTypePlaceholder.xyz = vs_PositionType[0].xyz; // + positionVector;

				velocityAgePlaceholder.xyz = positionVector * velocityMagnitude; 

				auxVecOnePlaceholder = vec4(vs_AuxVecOne[0].x, isItMustard, 0, 0);
				break;
			}
			case(9): {

				positionTypePlaceholder.xyz = vs_PositionType[0].xyz - vs_AuxVecOne[0].xyz * (1.0f + abs(positionVector.x)) * 200.0f;
				velocityAgePlaceholder.xyz = vec3(0.0);
				auxVecOnePlaceholder = vec4(vs_AuxVecOne[0].x, vs_AuxVecOne[0].y ,randomSeed3, 0);

				break;
			}					
			case(11): {
				
				float distanceBetweenParticles;

				vec3 goalToAim;
				vec3 displacementAddition;

				float increment;

				if(i <  emitCount11 / 2){
					goalToAim = normalize(primaryGoal - startingPosition);
					displacementAddition = startingPosition;
					distanceBetweenParticles = length(primaryGoal - startingPosition) / (emitCount / 2.0);
					increment = float(i);
				}else{
					goalToAim = normalize(secondaryGoal - primaryGoal);
					displacementAddition = primaryGoal;
					increment = float(i) - emitCount11 / 2.0;
					distanceBetweenParticles = length(secondaryGoal - primaryGoal) / (emitCount / 2.0);

				}

				vec3 particleDisplacement = (goalToAim * increment * distanceBetweenParticles) + displacementAddition;

				positionTypePlaceholder.xyz = vs_PositionType[0].xyz + particleDisplacement;
				velocityAgePlaceholder.xyz = vec3(0.0); 
				auxVecOnePlaceholder = vec4(vs_AuxVecOne[0].x, 0, 0, 0);

				break;
			}case(12): { //FIREWORKS_ROCKET
				positionTypePlaceholder.xyz = vs_PositionType[0].xyz + normalize(vs_PositionType[0].xyz) * positionVector.x;
				velocityAgePlaceholder.xyz = vec3(0.0);
				auxVecOnePlaceholder = vec4(vs_AuxVecOne[0].x,randomSeed2,randomSeed3, 0);

				break;
			}case(13): { //Firework EXPLOSION
				positionTypePlaceholder.xyz = vs_PositionType[0].xyz;
				velocityAgePlaceholder.xyz = positionVector.xyz * 25.0f;
				auxVecOnePlaceholder = vec4(vs_AuxVecOne[0].x, vs_VelocityAge[0].y ,randomSeed3, 0);

				break;
			}


			default:
				doEmit = false;
				break;
		}

		//this is here for each planetary location. Do not fuck with it. 
		positionTypePlaceholder.w = vs_PositionType[0].w;
		auxVecOnePlaceholder.w = vs_AuxVecOne[0].w;

		gs_PositionType = positionTypePlaceholder;
		gs_VelocityAge = velocityAgePlaceholder;
		gs_AuxVecOne = auxVecOnePlaceholder;

		if(doEmit==true){
			EmitVertex();
			EndPrimitive();
		}
	}  
}
void main()
{
  emitParticles(int(vs_PositionType[0].w));
}
